<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>@yield('title', 'Email Notification')</title>
    <style>
        body {
            font-family: 'Segoe UI', Roboto, Helvetica, Arial, sans-serif;
            background-color: #121212;
            margin: 0;
            padding: 0;
            color: #ffffff;
        }

        .email-wrapper {
            width: 100%;
            background-color: #121212;
            padding: 30px 0;
        }

        .email-container {
            max-width: 600px;
            margin: 0 auto;
            background-color: #1e1e1e;
            border-radius: 8px;
            overflow: hidden;
            box-shadow: 0 2px 6px rgba(0,0,0,0.4);
        }

        /* Blue header */
        .email-header {
            background-color: #004aad;
            text-align: center;
            padding: 25px 20px; /* larger height */
        }

        .email-header img {
            max-width: 110px;
            margin-bottom: 8px;
        }

        .email-header h2 {
            color: #ffffff;
            font-size: 22px;
            font-weight: 600;
            margin: 0;
        }

        /* Body content */
        .email-body {
            padding: 35px 30px;
            text-align: left;
            color: #e5e5e5;
        }

        .email-body h1, .email-body h2 {
            color: #ffffff;
            margin-bottom: 10px;
        }

        .email-body p {
            line-height: 1.6;
            color: #cccccc;
            margin: 10px 0;
        }

        /* Thanks section */
        .thanks {
            margin-top: 30px;
            color: #ffffff;
            font-weight: 500;
        }

        /* Footer section */
        .email-footer {
            background-color: #1a1a1a;
            color: #888;
            font-size: 13px;
            text-align: center;
            padding: 25px 20px;
            border-top: 1px solid #2d2d2d;
        }
        
        .address-section {
            background-color: #004aad;
            color: #ffffff;
            text-align: center;
            padding: 20px 10px;
            width: 100%;
            margin: 0;
        }

        .address-section p {
            margin: 8px 0;
            font-size: 15px;
            text-align: center;
            
        }

        .highlight {
            color: #4f8cff;
            font-weight: 600;
        }

        a {
            color: #4f8cff;
            text-decoration: none;
        }

        @media (max-width: 600px) {
            .email-container {
                width: 90%;
            }
        }
    </style>
</head>
<body>
    <div class="email-wrapper">
        <div class="email-container">
            <!-- HEADER -->
            <div class="email-header">
                @hasSection('logo')
                    @yield('logo')
                @else
                    <img src="https://quantiveou.com/storage/app/public/photos/ufhkMqauleV9vLKvgiNbfDmIqK5EJo4998eeK101.png" 
                         alt="Quantiveou Logo">
                @endif
                
            </div>

            <!-- BODY -->
            <div class="email-body">
                <h1>@yield('greeting', 'Hello,')</h1>
                <p>@yield('content')</p>
                @yield('additional_content')

                <p class="thanks">Thanks, 
                <strong>@yield('company_name', 'Quantiveou')</strong></p>
            </div>

            <!-- FOOTER -->
            <div class="email-footer">
                <p>DISCLAIMER: This message was automatically generated via 
                @yield('company_name', 'Quantiveou') secured online channel.
                Please do not reply to this message.</p>

                <p>&copy; {{ date('Y') }} @yield('company_name', 'Quantiveou'). All rights reserved.</p>
            </div>
            <div class="address-section">
            <p>@yield('address', 'Ranelagh Street, Liverpool L1 1JT')</p>
        </div>
        </div>
        
    </div>
</body>
</html>